// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.DeviceComplianceUserStatus;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Device Compliance User Status Request.
 */
public interface IDeviceComplianceUserStatusRequest extends IHttpRequest {

    /**
     * Gets the DeviceComplianceUserStatus from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<DeviceComplianceUserStatus> callback);

    /**
     * Gets the DeviceComplianceUserStatus from the service
     *
     * @return the DeviceComplianceUserStatus from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DeviceComplianceUserStatus get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<DeviceComplianceUserStatus> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this DeviceComplianceUserStatus with a source
     *
     * @param sourceDeviceComplianceUserStatus the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final DeviceComplianceUserStatus sourceDeviceComplianceUserStatus, final ICallback<DeviceComplianceUserStatus> callback);

    /**
     * Patches this DeviceComplianceUserStatus with a source
     *
     * @param sourceDeviceComplianceUserStatus the source object with updates
     * @return the updated DeviceComplianceUserStatus
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DeviceComplianceUserStatus patch(final DeviceComplianceUserStatus sourceDeviceComplianceUserStatus) throws ClientException;

    /**
     * Posts a DeviceComplianceUserStatus with a new object
     *
     * @param newDeviceComplianceUserStatus the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final DeviceComplianceUserStatus newDeviceComplianceUserStatus, final ICallback<DeviceComplianceUserStatus> callback);

    /**
     * Posts a DeviceComplianceUserStatus with a new object
     *
     * @param newDeviceComplianceUserStatus the new object to create
     * @return the created DeviceComplianceUserStatus
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DeviceComplianceUserStatus post(final DeviceComplianceUserStatus newDeviceComplianceUserStatus) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IDeviceComplianceUserStatusRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IDeviceComplianceUserStatusRequest expand(final String value);

}

