// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.CalendarPermission;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Calendar Permission Request.
 */
public interface ICalendarPermissionRequest extends IHttpRequest {

    /**
     * Gets the CalendarPermission from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<CalendarPermission> callback);

    /**
     * Gets the CalendarPermission from the service
     *
     * @return the CalendarPermission from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    CalendarPermission get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<CalendarPermission> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this CalendarPermission with a source
     *
     * @param sourceCalendarPermission the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final CalendarPermission sourceCalendarPermission, final ICallback<CalendarPermission> callback);

    /**
     * Patches this CalendarPermission with a source
     *
     * @param sourceCalendarPermission the source object with updates
     * @return the updated CalendarPermission
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    CalendarPermission patch(final CalendarPermission sourceCalendarPermission) throws ClientException;

    /**
     * Posts a CalendarPermission with a new object
     *
     * @param newCalendarPermission the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final CalendarPermission newCalendarPermission, final ICallback<CalendarPermission> callback);

    /**
     * Posts a CalendarPermission with a new object
     *
     * @param newCalendarPermission the new object to create
     * @return the created CalendarPermission
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    CalendarPermission post(final CalendarPermission newCalendarPermission) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    ICalendarPermissionRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    ICalendarPermissionRequest expand(final String value);

}

