// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IEventSnoozeReminderRequest;
import com.microsoft.graph.requests.extensions.EventSnoozeReminderRequest;
import com.microsoft.graph.models.extensions.DateTimeTimeZone;
import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.BaseFunctionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Event Snooze Reminder Request Builder.
 */
public class EventSnoozeReminderRequestBuilder extends BaseActionRequestBuilder implements IEventSnoozeReminderRequestBuilder {

    /**
     * The request builder for this EventSnoozeReminder
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param newReminderTime the newReminderTime
     */
    public EventSnoozeReminderRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, final DateTimeTimeZone newReminderTime) {
        super(requestUrl, client, requestOptions);
        bodyParams.put("newReminderTime", newReminderTime);
    }

    /**
     * Creates the IEventSnoozeReminderRequest
     *
     * @return the IEventSnoozeReminderRequest instance
     */
    public IEventSnoozeReminderRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IEventSnoozeReminderRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the IEventSnoozeReminderRequest instance
     */
    public IEventSnoozeReminderRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        EventSnoozeReminderRequest request = new EventSnoozeReminderRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("newReminderTime")) {
            request.body.newReminderTime = getParameter("newReminderTime");
        }

        return request;
    }
}
