// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IApplicationRemoveKeyRequest;
import com.microsoft.graph.requests.extensions.ApplicationRemoveKeyRequest;

import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.BaseFunctionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Application Remove Key Request Builder.
 */
public class ApplicationRemoveKeyRequestBuilder extends BaseActionRequestBuilder implements IApplicationRemoveKeyRequestBuilder {

    /**
     * The request builder for this ApplicationRemoveKey
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param keyId the keyId
     * @param proof the proof
     */
    public ApplicationRemoveKeyRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, final java.util.UUID keyId, final String proof) {
        super(requestUrl, client, requestOptions);
        bodyParams.put("keyId", keyId);
        bodyParams.put("proof", proof);
    }

    /**
     * Creates the IApplicationRemoveKeyRequest
     *
     * @return the IApplicationRemoveKeyRequest instance
     */
    public IApplicationRemoveKeyRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IApplicationRemoveKeyRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the IApplicationRemoveKeyRequest instance
     */
    public IApplicationRemoveKeyRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        ApplicationRemoveKeyRequest request = new ApplicationRemoveKeyRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("keyId")) {
            request.body.keyId = getParameter("keyId");
        }

        if (hasParameter("proof")) {
            request.body.proof = getParameter("proof");
        }

        return request;
    }
}
