// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.models.extensions.AutomaticRepliesSetting;
import com.microsoft.graph.models.extensions.LocaleInfo;
import com.microsoft.graph.models.generated.DelegateMeetingMessageDeliveryOptions;
import com.microsoft.graph.models.extensions.WorkingHours;


import com.google.gson.JsonObject;
import com.google.gson.JsonElement;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;
import java.util.Map;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Mailbox Settings.
 */
public class MailboxSettings implements IJsonBackedObject {

    @SerializedName("@odata.type")
    @Expose
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Automatic Replies Setting.
     * Configuration settings to automatically notify the sender of an incoming email with a message from the signed-in user.
     */
    @SerializedName("automaticRepliesSetting")
    @Expose
    public AutomaticRepliesSetting automaticRepliesSetting;

    /**
     * The Archive Folder.
     * Folder ID of an archive folder for the user.
     */
    @SerializedName("archiveFolder")
    @Expose
    public String archiveFolder;

    /**
     * The Time Zone.
     * The default time zone for the user's mailbox.
     */
    @SerializedName("timeZone")
    @Expose
    public String timeZone;

    /**
     * The Language.
     * The locale information for the user, including the preferred language and country/region.
     */
    @SerializedName("language")
    @Expose
    public LocaleInfo language;

    /**
     * The Delegate Meeting Message Delivery Options.
     * If the user has a calendar delegate, this specifies whether the delegate, mailbox owner, or both receive meeting messages and meeting responses. Possible values are: sendToDelegateAndInformationToPrincipal, sendToDelegateAndPrincipal, sendToDelegateOnly.
     */
    @SerializedName("delegateMeetingMessageDeliveryOptions")
    @Expose
    public DelegateMeetingMessageDeliveryOptions delegateMeetingMessageDeliveryOptions;

    /**
     * The Working Hours.
     * The days of the week and hours in a specific time zone that the user works.
     */
    @SerializedName("workingHours")
    @Expose
    public WorkingHours workingHours;

    /**
     * The Date Format.
     * The date format for the user's mailbox.
     */
    @SerializedName("dateFormat")
    @Expose
    public String dateFormat;

    /**
     * The Time Format.
     * The time format for the user's mailbox.
     */
    @SerializedName("timeFormat")
    @Expose
    public String timeFormat;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;

    }
}
