// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.models.extensions.DeviceCompliancePolicySettingState;
import com.microsoft.graph.models.generated.PolicyPlatformType;
import com.microsoft.graph.models.generated.ComplianceStatus;
import com.microsoft.graph.models.extensions.Entity;


import com.google.gson.JsonObject;
import com.google.gson.JsonElement;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;
import java.util.Map;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Device Compliance Policy State.
 */
public class DeviceCompliancePolicyState extends Entity implements IJsonBackedObject {


    /**
     * The Setting States.
     * 
     */
    @SerializedName("settingStates")
    @Expose
    public java.util.List<DeviceCompliancePolicySettingState> settingStates;

    /**
     * The Display Name.
     * The name of the policy for this policyBase
     */
    @SerializedName("displayName")
    @Expose
    public String displayName;

    /**
     * The Version.
     * The version of the policy
     */
    @SerializedName("version")
    @Expose
    public Integer version;

    /**
     * The Platform Type.
     * Platform type that the policy applies to
     */
    @SerializedName("platformType")
    @Expose
    public PolicyPlatformType platformType;

    /**
     * The State.
     * The compliance state of the policy
     */
    @SerializedName("state")
    @Expose
    public ComplianceStatus state;

    /**
     * The Setting Count.
     * Count of how many setting a policy holds
     */
    @SerializedName("settingCount")
    @Expose
    public Integer settingCount;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;

    }
}
