// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.models.extensions.SignIn;
import com.microsoft.graph.models.extensions.DirectoryAudit;
import com.microsoft.graph.models.extensions.RestrictedSignIn;
import com.microsoft.graph.models.extensions.Entity;
import com.microsoft.graph.requests.extensions.SignInCollectionResponse;
import com.microsoft.graph.requests.extensions.SignInCollectionPage;
import com.microsoft.graph.requests.extensions.DirectoryAuditCollectionResponse;
import com.microsoft.graph.requests.extensions.DirectoryAuditCollectionPage;
import com.microsoft.graph.requests.extensions.RestrictedSignInCollectionResponse;
import com.microsoft.graph.requests.extensions.RestrictedSignInCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.JsonElement;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;
import java.util.Map;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Audit Log Root.
 */
public class AuditLogRoot extends Entity implements IJsonBackedObject {


    /**
     * The Sign Ins.
     * Read-only. Nullable.
     */
    public SignInCollectionPage signIns;

    /**
     * The Directory Audits.
     * Read-only. Nullable.
     */
    public DirectoryAuditCollectionPage directoryAudits;

    /**
     * The Restricted Sign Ins.
     * 
     */
    public RestrictedSignInCollectionPage restrictedSignIns;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;


        if (json.has("signIns")) {
            final SignInCollectionResponse response = new SignInCollectionResponse();
            if (json.has("signIns@odata.nextLink")) {
                response.nextLink = json.get("signIns@odata.nextLink").getAsString();
            }

            final JsonObject[] sourceArray = serializer.deserializeObject(json.get("signIns").toString(), JsonObject[].class);
            final SignIn[] array = new SignIn[sourceArray.length];
            for (int i = 0; i < sourceArray.length; i++) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), SignIn.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            signIns = new SignInCollectionPage(response, null);
        }

        if (json.has("directoryAudits")) {
            final DirectoryAuditCollectionResponse response = new DirectoryAuditCollectionResponse();
            if (json.has("directoryAudits@odata.nextLink")) {
                response.nextLink = json.get("directoryAudits@odata.nextLink").getAsString();
            }

            final JsonObject[] sourceArray = serializer.deserializeObject(json.get("directoryAudits").toString(), JsonObject[].class);
            final DirectoryAudit[] array = new DirectoryAudit[sourceArray.length];
            for (int i = 0; i < sourceArray.length; i++) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), DirectoryAudit.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            directoryAudits = new DirectoryAuditCollectionPage(response, null);
        }

        if (json.has("restrictedSignIns")) {
            final RestrictedSignInCollectionResponse response = new RestrictedSignInCollectionResponse();
            if (json.has("restrictedSignIns@odata.nextLink")) {
                response.nextLink = json.get("restrictedSignIns@odata.nextLink").getAsString();
            }

            final JsonObject[] sourceArray = serializer.deserializeObject(json.get("restrictedSignIns").toString(), JsonObject[].class);
            final RestrictedSignIn[] array = new RestrictedSignIn[sourceArray.length];
            for (int i = 0; i < sourceArray.length; i++) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), RestrictedSignIn.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            restrictedSignIns = new RestrictedSignInCollectionPage(response, null);
        }
    }
}
