/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.TeamsTemplate;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ITeamsTemplateCollectionPage;
import com.microsoft.graph.requests.extensions.ITeamsTemplateCollectionRequest;
import com.microsoft.graph.requests.extensions.TeamsTemplateCollectionPage;
import com.microsoft.graph.requests.extensions.TeamsTemplateCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.TeamsTemplateCollectionResponse;
import com.microsoft.graph.requests.extensions.TeamsTemplateRequestBuilder;
import java.util.List;

public class TeamsTemplateCollectionRequest
extends BaseCollectionRequest<TeamsTemplateCollectionResponse, ITeamsTemplateCollectionPage>
implements ITeamsTemplateCollectionRequest {
    public TeamsTemplateCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, TeamsTemplateCollectionResponse.class, ITeamsTemplateCollectionPage.class);
    }

    @Override
    public void get(final ICallback<ITeamsTemplateCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(TeamsTemplateCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ITeamsTemplateCollectionPage get() throws ClientException {
        TeamsTemplateCollectionResponse response = (TeamsTemplateCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(TeamsTemplate newTeamsTemplate, ICallback<TeamsTemplate> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new TeamsTemplateRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newTeamsTemplate, callback);
    }

    @Override
    public TeamsTemplate post(TeamsTemplate newTeamsTemplate) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new TeamsTemplateRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newTeamsTemplate);
    }

    @Override
    public ITeamsTemplateCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public ITeamsTemplateCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ITeamsTemplateCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public ITeamsTemplateCollectionPage buildFromResponse(TeamsTemplateCollectionResponse response) {
        TeamsTemplateCollectionRequestBuilder builder = response.nextLink != null ? new TeamsTemplateCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        TeamsTemplateCollectionPage page = new TeamsTemplateCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

