/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.PermissionGrantBody;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IPermissionGrantCollectionPage;
import com.microsoft.graph.requests.extensions.IPermissionGrantCollectionRequest;
import com.microsoft.graph.requests.extensions.PermissionGrantCollectionPage;
import com.microsoft.graph.requests.extensions.PermissionGrantCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.PermissionGrantCollectionResponse;
import java.util.List;

public class PermissionGrantCollectionRequest
extends BaseCollectionRequest<PermissionGrantCollectionResponse, IPermissionGrantCollectionPage>
implements IPermissionGrantCollectionRequest {
    protected final PermissionGrantBody body = new PermissionGrantBody();

    public PermissionGrantCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, PermissionGrantCollectionResponse.class, IPermissionGrantCollectionPage.class);
    }

    @Override
    public void post(final ICallback<IPermissionGrantCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(PermissionGrantCollectionRequest.this.post(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IPermissionGrantCollectionPage post() throws ClientException {
        PermissionGrantCollectionResponse response = (PermissionGrantCollectionResponse)this.post(this.body);
        return this.buildFromResponse(response);
    }

    public IPermissionGrantCollectionPage buildFromResponse(PermissionGrantCollectionResponse response) {
        PermissionGrantCollectionRequestBuilder builder = response.nextLink != null ? new PermissionGrantCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null, null, null) : null;
        PermissionGrantCollectionPage page = new PermissionGrantCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    @Override
    public IPermissionGrantCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IPermissionGrantCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IPermissionGrantCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }
}

