/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.Participant;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IParticipantCollectionPage;
import com.microsoft.graph.requests.extensions.IParticipantCollectionRequest;
import com.microsoft.graph.requests.extensions.ParticipantCollectionPage;
import com.microsoft.graph.requests.extensions.ParticipantCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ParticipantCollectionResponse;
import com.microsoft.graph.requests.extensions.ParticipantRequestBuilder;
import java.util.List;

public class ParticipantCollectionRequest
extends BaseCollectionRequest<ParticipantCollectionResponse, IParticipantCollectionPage>
implements IParticipantCollectionRequest {
    public ParticipantCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ParticipantCollectionResponse.class, IParticipantCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IParticipantCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(ParticipantCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IParticipantCollectionPage get() throws ClientException {
        ParticipantCollectionResponse response = (ParticipantCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(Participant newParticipant, ICallback<Participant> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ParticipantRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newParticipant, callback);
    }

    @Override
    public Participant post(Participant newParticipant) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ParticipantRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newParticipant);
    }

    @Override
    public IParticipantCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IParticipantCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IParticipantCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IParticipantCollectionPage buildFromResponse(ParticipantCollectionResponse response) {
        ParticipantCollectionRequestBuilder builder = response.nextLink != null ? new ParticipantCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ParticipantCollectionPage page = new ParticipantCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

