/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.ChatMessageHostedContent;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ChatMessageHostedContentCollectionPage;
import com.microsoft.graph.requests.extensions.ChatMessageHostedContentCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ChatMessageHostedContentCollectionResponse;
import com.microsoft.graph.requests.extensions.ChatMessageHostedContentRequestBuilder;
import com.microsoft.graph.requests.extensions.IChatMessageHostedContentCollectionPage;
import com.microsoft.graph.requests.extensions.IChatMessageHostedContentCollectionRequest;
import java.util.List;

public class ChatMessageHostedContentCollectionRequest
extends BaseCollectionRequest<ChatMessageHostedContentCollectionResponse, IChatMessageHostedContentCollectionPage>
implements IChatMessageHostedContentCollectionRequest {
    public ChatMessageHostedContentCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ChatMessageHostedContentCollectionResponse.class, IChatMessageHostedContentCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IChatMessageHostedContentCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(ChatMessageHostedContentCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IChatMessageHostedContentCollectionPage get() throws ClientException {
        ChatMessageHostedContentCollectionResponse response = (ChatMessageHostedContentCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(ChatMessageHostedContent newChatMessageHostedContent, ICallback<ChatMessageHostedContent> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ChatMessageHostedContentRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newChatMessageHostedContent, callback);
    }

    @Override
    public ChatMessageHostedContent post(ChatMessageHostedContent newChatMessageHostedContent) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ChatMessageHostedContentRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newChatMessageHostedContent);
    }

    @Override
    public IChatMessageHostedContentCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IChatMessageHostedContentCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IChatMessageHostedContentCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IChatMessageHostedContentCollectionPage buildFromResponse(ChatMessageHostedContentCollectionResponse response) {
        ChatMessageHostedContentCollectionRequestBuilder builder = response.nextLink != null ? new ChatMessageHostedContentCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ChatMessageHostedContentCollectionPage page = new ChatMessageHostedContentCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

