/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.extensions;

import com.google.gson.JsonObject;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.microsoft.graph.models.extensions.Entity;
import com.microsoft.graph.models.extensions.WorkbookFormatProtection;
import com.microsoft.graph.models.extensions.WorkbookRangeBorder;
import com.microsoft.graph.models.extensions.WorkbookRangeFill;
import com.microsoft.graph.models.extensions.WorkbookRangeFont;
import com.microsoft.graph.requests.extensions.WorkbookRangeBorderCollectionPage;
import com.microsoft.graph.requests.extensions.WorkbookRangeBorderCollectionResponse;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.ISerializer;
import java.util.Arrays;

public class WorkbookRangeFormat
extends Entity
implements IJsonBackedObject {
    @SerializedName(value="columnWidth")
    @Expose
    public Double columnWidth;
    @SerializedName(value="horizontalAlignment")
    @Expose
    public String horizontalAlignment;
    @SerializedName(value="rowHeight")
    @Expose
    public Double rowHeight;
    @SerializedName(value="verticalAlignment")
    @Expose
    public String verticalAlignment;
    @SerializedName(value="wrapText")
    @Expose
    public Boolean wrapText;
    public WorkbookRangeBorderCollectionPage borders;
    @SerializedName(value="fill")
    @Expose
    public WorkbookRangeFill fill;
    @SerializedName(value="font")
    @Expose
    public WorkbookRangeFont font;
    @SerializedName(value="protection")
    @Expose
    public WorkbookFormatProtection protection;
    private JsonObject rawObject;
    private ISerializer serializer;

    @Override
    public JsonObject getRawObject() {
        return this.rawObject;
    }

    @Override
    protected ISerializer getSerializer() {
        return this.serializer;
    }

    @Override
    public void setRawObject(ISerializer serializer, JsonObject json) {
        this.serializer = serializer;
        this.rawObject = json;
        if (json.has("borders")) {
            WorkbookRangeBorderCollectionResponse response = new WorkbookRangeBorderCollectionResponse();
            if (json.has("borders@odata.nextLink")) {
                response.nextLink = json.get("borders@odata.nextLink").getAsString();
            }
            JsonObject[] sourceArray = serializer.deserializeObject(json.get("borders").toString(), JsonObject[].class);
            WorkbookRangeBorder[] array = new WorkbookRangeBorder[sourceArray.length];
            for (int i = 0; i < sourceArray.length; ++i) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), WorkbookRangeBorder.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            this.borders = new WorkbookRangeBorderCollectionPage(response, null);
        }
    }
}

