// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Site Add Collection Request.
 */
public class SiteAddCollectionRequest extends BaseCollectionRequest<SiteAddCollectionResponse, ISiteAddCollectionPage> implements ISiteAddCollectionRequest {


    protected final SiteAddBody body;


    /**
     * The request for this SiteAdd
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public SiteAddCollectionRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, SiteAddCollectionResponse.class, ISiteAddCollectionPage.class);
        body = new SiteAddBody();
    }


    public void post(final ICallback<ISiteAddCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(post(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public ISiteAddCollectionPage post() throws ClientException {
        final SiteAddCollectionResponse response = post(body);
        return buildFromResponse(response);
    }


    public ISiteAddCollectionPage buildFromResponse(final SiteAddCollectionResponse response) {
        final ISiteAddCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new SiteAddCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null, /* value */ null);
        } else {
            builder = null;
        }
        final ISiteAddCollectionPage page = new SiteAddCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public ISiteAddCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("$select", value));
        return (ISiteAddCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value the max number of items to return
     * @return the updated request
     */
    public ISiteAddCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("$top", value+""));
        return (ISiteAddCollectionRequest)this;
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public ISiteAddCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("$expand", value));
        return (ISiteAddCollectionRequest)this;
    }

}
