// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IServicePrincipalRemovePasswordRequest;
import com.microsoft.graph.requests.extensions.ServicePrincipalRemovePasswordRequest;

import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.BaseFunctionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.FunctionOption;
import com.google.gson.JsonElement;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Service Principal Remove Password Request Builder.
 */
public class ServicePrincipalRemovePasswordRequestBuilder extends BaseActionRequestBuilder implements IServicePrincipalRemovePasswordRequestBuilder {

    /**
     * The request builder for this ServicePrincipalRemovePassword
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param keyId the keyId
     */
    public ServicePrincipalRemovePasswordRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions, final java.util.UUID keyId) {
        super(requestUrl, client, requestOptions);
        bodyParams.put("keyId", keyId);
    }

    /**
     * Creates the IServicePrincipalRemovePasswordRequest
     *
     * @return the IServicePrincipalRemovePasswordRequest instance
     */
    public IServicePrincipalRemovePasswordRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IServicePrincipalRemovePasswordRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the IServicePrincipalRemovePasswordRequest instance
     */
    public IServicePrincipalRemovePasswordRequest buildRequest(final java.util.List<? extends Option> requestOptions) {
        ServicePrincipalRemovePasswordRequest request = new ServicePrincipalRemovePasswordRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("keyId")) {
            request.body.keyId = getParameter("keyId");
        }

        return request;
    }
}
