// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Managed EBook Assignment Collection Request.
 */
public class ManagedEBookAssignmentCollectionRequest extends BaseCollectionRequest<ManagedEBookAssignmentCollectionResponse, IManagedEBookAssignmentCollectionPage> implements IManagedEBookAssignmentCollectionRequest {

    /**
     * The request builder for this collection of ManagedEBookAssignment
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ManagedEBookAssignmentCollectionRequest(final String requestUrl, IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ManagedEBookAssignmentCollectionResponse.class, IManagedEBookAssignmentCollectionPage.class);
    }

    public void get(final ICallback<IManagedEBookAssignmentCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public IManagedEBookAssignmentCollectionPage get() throws ClientException {
        final ManagedEBookAssignmentCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final ManagedEBookAssignment newManagedEBookAssignment, final ICallback<ManagedEBookAssignment> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new ManagedEBookAssignmentRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newManagedEBookAssignment, callback);
    }

    public ManagedEBookAssignment post(final ManagedEBookAssignment newManagedEBookAssignment) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new ManagedEBookAssignmentRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newManagedEBookAssignment);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public IManagedEBookAssignmentCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("$expand", value));
        return (ManagedEBookAssignmentCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public IManagedEBookAssignmentCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("$select", value));
        return (ManagedEBookAssignmentCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value the max number of items to return
     * @return the updated request
     */
    public IManagedEBookAssignmentCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("$top", value + ""));
        return (ManagedEBookAssignmentCollectionRequest)this;
    }

    public IManagedEBookAssignmentCollectionPage buildFromResponse(final ManagedEBookAssignmentCollectionResponse response) {
        final IManagedEBookAssignmentCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new ManagedEBookAssignmentCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final ManagedEBookAssignmentCollectionPage page = new ManagedEBookAssignmentCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
