// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Token Issuance Policy With Reference Request.
 */
public interface ITokenIssuancePolicyWithReferenceRequest extends IHttpRequest {

    void post(final TokenIssuancePolicy newTokenIssuancePolicy, final IJsonBackedObject payload, final ICallback<TokenIssuancePolicy> callback);

    TokenIssuancePolicy post(final TokenIssuancePolicy newTokenIssuancePolicy, final IJsonBackedObject payload) throws ClientException;

    void get(final ICallback<TokenIssuancePolicy> callback);

    TokenIssuancePolicy get() throws ClientException;

	void delete(final ICallback<TokenIssuancePolicy> callback);

	void delete() throws ClientException;

	void patch(final TokenIssuancePolicy sourceTokenIssuancePolicy, final ICallback<TokenIssuancePolicy> callback);

	TokenIssuancePolicy patch(final TokenIssuancePolicy sourceTokenIssuancePolicy) throws ClientException;

    ITokenIssuancePolicyWithReferenceRequest select(final String value);

    ITokenIssuancePolicyWithReferenceRequest expand(final String value);

}
