// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.TimeOffReason;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Time Off Reason Request.
 */
public interface ITimeOffReasonRequest extends IHttpRequest {

    /**
     * Gets the TimeOffReason from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<TimeOffReason> callback);

    /**
     * Gets the TimeOffReason from the service
     *
     * @return the TimeOffReason from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    TimeOffReason get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<TimeOffReason> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this TimeOffReason with a source
     *
     * @param sourceTimeOffReason the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final TimeOffReason sourceTimeOffReason, final ICallback<TimeOffReason> callback);

    /**
     * Patches this TimeOffReason with a source
     *
     * @param sourceTimeOffReason the source object with updates
     * @return the updated TimeOffReason
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    TimeOffReason patch(final TimeOffReason sourceTimeOffReason) throws ClientException;

    /**
     * Posts a TimeOffReason with a new object
     *
     * @param newTimeOffReason the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final TimeOffReason newTimeOffReason, final ICallback<TimeOffReason> callback);

    /**
     * Posts a TimeOffReason with a new object
     *
     * @param newTimeOffReason the new object to create
     * @return the created TimeOffReason
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    TimeOffReason post(final TimeOffReason newTimeOffReason) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    ITimeOffReasonRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    ITimeOffReasonRequest expand(final String value);

}

