// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IThreatAssessmentRequestRequest;
import com.microsoft.graph.requests.extensions.IThreatAssessmentResultCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IThreatAssessmentResultRequestBuilder;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Threat Assessment Request Request Builder.
 */
public interface IThreatAssessmentRequestRequestBuilder extends IRequestBuilder {
    /**
     * Creates the request
     *
     * @return the IThreatAssessmentRequestRequest instance
     */
    IThreatAssessmentRequestRequest buildRequest();

    /**
     * Creates the request with specific options instead of the existing options
     *
     * @param requestOptions the options for this request
     * @return the IThreatAssessmentRequestRequest instance
     */
    IThreatAssessmentRequestRequest buildRequest(final java.util.List<? extends Option> requestOptions);


    IThreatAssessmentResultCollectionRequestBuilder results();

    IThreatAssessmentResultRequestBuilder results(final String id);

}
