// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.ShiftPreferences;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Shift Preferences Request.
 */
public interface IShiftPreferencesRequest extends IHttpRequest {

    /**
     * Gets the ShiftPreferences from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<ShiftPreferences> callback);

    /**
     * Gets the ShiftPreferences from the service
     *
     * @return the ShiftPreferences from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ShiftPreferences get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<ShiftPreferences> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this ShiftPreferences with a source
     *
     * @param sourceShiftPreferences the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final ShiftPreferences sourceShiftPreferences, final ICallback<ShiftPreferences> callback);

    /**
     * Patches this ShiftPreferences with a source
     *
     * @param sourceShiftPreferences the source object with updates
     * @return the updated ShiftPreferences
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ShiftPreferences patch(final ShiftPreferences sourceShiftPreferences) throws ClientException;

    /**
     * Posts a ShiftPreferences with a new object
     *
     * @param newShiftPreferences the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final ShiftPreferences newShiftPreferences, final ICallback<ShiftPreferences> callback);

    /**
     * Posts a ShiftPreferences with a new object
     *
     * @param newShiftPreferences the new object to create
     * @return the created ShiftPreferences
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ShiftPreferences post(final ShiftPreferences newShiftPreferences) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IShiftPreferencesRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IShiftPreferencesRequest expand(final String value);

}

