// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IRoomListRequest;
import com.microsoft.graph.requests.extensions.IRoomCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IRoomRequestBuilder;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Room List Request Builder.
 */
public interface IRoomListRequestBuilder extends IRequestBuilder {
    /**
     * Creates the request
     *
     * @return the IRoomListRequest instance
     */
    IRoomListRequest buildRequest();

    /**
     * Creates the request with specific options instead of the existing options
     *
     * @param requestOptions the options for this request
     * @return the IRoomListRequest instance
     */
    IRoomListRequest buildRequest(final java.util.List<? extends Option> requestOptions);


    IRoomCollectionRequestBuilder rooms();

    IRoomRequestBuilder rooms(final String id);

}
