// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Endpoint Collection Request.
 */
public class EndpointCollectionRequest extends BaseCollectionRequest<EndpointCollectionResponse, IEndpointCollectionPage> implements IEndpointCollectionRequest {

    /**
     * The request builder for this collection of Endpoint
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public EndpointCollectionRequest(final String requestUrl, IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, EndpointCollectionResponse.class, IEndpointCollectionPage.class);
    }

    public void get(final ICallback<IEndpointCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public IEndpointCollectionPage get() throws ClientException {
        final EndpointCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final Endpoint newEndpoint, final ICallback<Endpoint> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new EndpointRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newEndpoint, callback);
    }

    public Endpoint post(final Endpoint newEndpoint) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new EndpointRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newEndpoint);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public IEndpointCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("$expand", value));
        return (EndpointCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public IEndpointCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("$select", value));
        return (EndpointCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value the max number of items to return
     * @return the updated request
     */
    public IEndpointCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("$top", value + ""));
        return (EndpointCollectionRequest)this;
    }

    public IEndpointCollectionPage buildFromResponse(final EndpointCollectionResponse response) {
        final IEndpointCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new EndpointCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final EndpointCollectionPage page = new EndpointCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
