// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Call Collection Request.
 */
public class CallCollectionRequest extends BaseCollectionRequest<CallCollectionResponse, ICallCollectionPage> implements ICallCollectionRequest {

    /**
     * The request builder for this collection of Call
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public CallCollectionRequest(final String requestUrl, IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, CallCollectionResponse.class, ICallCollectionPage.class);
    }

    public void get(final ICallback<ICallCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public ICallCollectionPage get() throws ClientException {
        final CallCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final Call newCall, final ICallback<Call> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new CallRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newCall, callback);
    }

    public Call post(final Call newCall) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new CallRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newCall);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public ICallCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("$expand", value));
        return (CallCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public ICallCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("$select", value));
        return (CallCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value the max number of items to return
     * @return the updated request
     */
    public ICallCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("$top", value + ""));
        return (CallCollectionRequest)this;
    }

    public ICallCollectionPage buildFromResponse(final CallCollectionResponse response) {
        final ICallCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new CallCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final CallCollectionPage page = new CallCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
