// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Calendar Permission Collection Request.
 */
public class CalendarPermissionCollectionRequest extends BaseCollectionRequest<CalendarPermissionCollectionResponse, ICalendarPermissionCollectionPage> implements ICalendarPermissionCollectionRequest {

    /**
     * The request builder for this collection of CalendarPermission
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public CalendarPermissionCollectionRequest(final String requestUrl, IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, CalendarPermissionCollectionResponse.class, ICalendarPermissionCollectionPage.class);
    }

    public void get(final ICallback<ICalendarPermissionCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public ICalendarPermissionCollectionPage get() throws ClientException {
        final CalendarPermissionCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final CalendarPermission newCalendarPermission, final ICallback<CalendarPermission> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new CalendarPermissionRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newCalendarPermission, callback);
    }

    public CalendarPermission post(final CalendarPermission newCalendarPermission) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new CalendarPermissionRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newCalendarPermission);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public ICalendarPermissionCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("$expand", value));
        return (CalendarPermissionCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public ICalendarPermissionCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("$select", value));
        return (CalendarPermissionCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value the max number of items to return
     * @return the updated request
     */
    public ICalendarPermissionCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("$top", value + ""));
        return (CalendarPermissionCollectionRequest)this;
    }

    public ICalendarPermissionCollectionPage buildFromResponse(final CalendarPermissionCollectionResponse response) {
        final ICalendarPermissionCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new CalendarPermissionCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final CalendarPermissionCollectionPage page = new CalendarPermissionCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
