// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IApplicationAddPasswordRequest;
import com.microsoft.graph.requests.extensions.ApplicationAddPasswordRequest;
import com.microsoft.graph.models.extensions.PasswordCredential;

import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.BaseFunctionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.FunctionOption;
import com.google.gson.JsonElement;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Application Add Password Request Builder.
 */
public class ApplicationAddPasswordRequestBuilder extends BaseActionRequestBuilder implements IApplicationAddPasswordRequestBuilder {

    /**
     * The request builder for this ApplicationAddPassword
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param passwordCredential the passwordCredential
     */
    public ApplicationAddPasswordRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions, final PasswordCredential passwordCredential) {
        super(requestUrl, client, requestOptions);
        bodyParams.put("passwordCredential", passwordCredential);
    }

    /**
     * Creates the IApplicationAddPasswordRequest
     *
     * @return the IApplicationAddPasswordRequest instance
     */
    public IApplicationAddPasswordRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IApplicationAddPasswordRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the IApplicationAddPasswordRequest instance
     */
    public IApplicationAddPasswordRequest buildRequest(final java.util.List<? extends Option> requestOptions) {
        ApplicationAddPasswordRequest request = new ApplicationAddPasswordRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("passwordCredential")) {
            request.body.passwordCredential = getParameter("passwordCredential");
        }

        return request;
    }
}
