// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.models.extensions.ConditionalAccessApplications;
import com.microsoft.graph.models.extensions.ConditionalAccessUsers;
import com.microsoft.graph.models.generated.RiskLevel;
import com.microsoft.graph.models.extensions.ConditionalAccessPlatforms;
import com.microsoft.graph.models.extensions.ConditionalAccessLocations;
import com.microsoft.graph.models.generated.ConditionalAccessClientApp;
import com.microsoft.graph.models.extensions.ConditionalAccessDevices;


import com.google.gson.JsonObject;
import com.google.gson.JsonElement;
import com.google.gson.annotations.*;
import java.util.HashMap;
import java.util.Map;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Conditional Access Condition Set.
 */
public class ConditionalAccessConditionSet implements IJsonBackedObject {

    @SerializedName("@odata.type")
    @Expose
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Applications.
     * 
     */
    @SerializedName("applications")
    @Expose
    public ConditionalAccessApplications applications;

    /**
     * The Users.
     * 
     */
    @SerializedName("users")
    @Expose
    public ConditionalAccessUsers users;

    /**
     * The Sign In Risk Levels.
     * 
     */
    @SerializedName("signInRiskLevels")
    @Expose
    public java.util.List<RiskLevel> signInRiskLevels;

    /**
     * The Platforms.
     * 
     */
    @SerializedName("platforms")
    @Expose
    public ConditionalAccessPlatforms platforms;

    /**
     * The Locations.
     * 
     */
    @SerializedName("locations")
    @Expose
    public ConditionalAccessLocations locations;

    /**
     * The Client App Types.
     * 
     */
    @SerializedName("clientAppTypes")
    @Expose
    public java.util.List<ConditionalAccessClientApp> clientAppTypes;

    /**
     * The Devices.
     * 
     */
    @SerializedName("devices")
    @Expose
    public ConditionalAccessDevices devices;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;

    }
}
