// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.DomainDnsRecord;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Domain Dns Record Request.
 */
public interface IDomainDnsRecordRequest extends IHttpRequest {

    /**
     * Gets the DomainDnsRecord from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<DomainDnsRecord> callback);

    /**
     * Gets the DomainDnsRecord from the service
     *
     * @return the DomainDnsRecord from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DomainDnsRecord get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<DomainDnsRecord> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this DomainDnsRecord with a source
     *
     * @param sourceDomainDnsRecord the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final DomainDnsRecord sourceDomainDnsRecord, final ICallback<DomainDnsRecord> callback);

    /**
     * Patches this DomainDnsRecord with a source
     *
     * @param sourceDomainDnsRecord the source object with updates
     * @return the updated DomainDnsRecord
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DomainDnsRecord patch(final DomainDnsRecord sourceDomainDnsRecord) throws ClientException;

    /**
     * Posts a DomainDnsRecord with a new object
     *
     * @param newDomainDnsRecord the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final DomainDnsRecord newDomainDnsRecord, final ICallback<DomainDnsRecord> callback);

    /**
     * Posts a DomainDnsRecord with a new object
     *
     * @param newDomainDnsRecord the new object to create
     * @return the created DomainDnsRecord
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DomainDnsRecord post(final DomainDnsRecord newDomainDnsRecord) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IDomainDnsRecordRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IDomainDnsRecordRequest expand(final String value);

}

