// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.Device;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Device Request.
 */
public interface IDeviceRequest extends IHttpRequest {

    /**
     * Gets the Device from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<Device> callback);

    /**
     * Gets the Device from the service
     *
     * @return the Device from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Device get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<Device> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this Device with a source
     *
     * @param sourceDevice the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final Device sourceDevice, final ICallback<Device> callback);

    /**
     * Patches this Device with a source
     *
     * @param sourceDevice the source object with updates
     * @return the updated Device
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Device patch(final Device sourceDevice) throws ClientException;

    /**
     * Posts a Device with a new object
     *
     * @param newDevice the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final Device newDevice, final ICallback<Device> callback);

    /**
     * Posts a Device with a new object
     *
     * @param newDevice the new object to create
     * @return the created Device
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Device post(final Device newDevice) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IDeviceRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IDeviceRequest expand(final String value);

}

