/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.concurrency;

import com.microsoft.graph.concurrency.ChunkedUploadResponseHandler;
import com.microsoft.graph.concurrency.IProgressCallback;
import com.microsoft.graph.models.extensions.IGraphServiceClient;
import com.microsoft.graph.models.extensions.UploadSession;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.extensions.ChunkedUploadRequest;
import com.microsoft.graph.requests.extensions.ChunkedUploadResult;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidParameterException;
import java.util.List;

public class ChunkedUploadProvider<UploadType> {
    private static final int DEFAULT_CHUNK_SIZE = 0x500000;
    private static final int REQUIRED_CHUNK_SIZE_INCREMENT = 327680;
    private static final int MAXIMUM_CHUNK_SIZE = 0x3C00000;
    private static final int MAXIMUM_RETRY_TIMES = 3;
    private final IGraphServiceClient client;
    private final InputStream inputStream;
    private final String uploadUrl;
    private final long streamSize;
    private final ChunkedUploadResponseHandler<UploadType> responseHandler;
    private long readSoFar;

    public ChunkedUploadProvider(UploadSession uploadSession, IGraphServiceClient client, InputStream inputStream, long streamSize, Class<UploadType> uploadTypeClass) {
        if (uploadSession == null) {
            throw new InvalidParameterException("Upload session is null.");
        }
        if (client == null) {
            throw new InvalidParameterException("OneDrive client is null.");
        }
        if (inputStream == null) {
            throw new InvalidParameterException("Input stream is null.");
        }
        if (streamSize <= 0L) {
            throw new InvalidParameterException("Stream size should larger than 0.");
        }
        this.client = client;
        this.readSoFar = 0L;
        this.inputStream = inputStream;
        this.streamSize = streamSize;
        this.uploadUrl = uploadSession.uploadUrl;
        this.responseHandler = new ChunkedUploadResponseHandler<UploadType>(uploadTypeClass);
    }

    public void upload(List<Option> options, IProgressCallback<UploadType> callback, int ... configs) throws IOException {
        int read;
        int chunkSize = 0x500000;
        if (configs.length > 0) {
            chunkSize = configs[0];
        }
        int maxRetry = 3;
        if (configs.length > 1) {
            maxRetry = configs[1];
        }
        if (chunkSize % 327680 != 0) {
            throw new IllegalArgumentException("Chunk size must be a multiple of 320 KiB");
        }
        if (chunkSize > 0x3C00000) {
            throw new IllegalArgumentException("Please set chunk size smaller than 60 MiB");
        }
        byte[] buffer = new byte[chunkSize];
        while (this.readSoFar < this.streamSize && (read = this.inputStream.read(buffer)) != -1) {
            ChunkedUploadRequest request = new ChunkedUploadRequest(this.uploadUrl, this.client, options, buffer, read, maxRetry, this.readSoFar, this.streamSize);
            ChunkedUploadResult<UploadType> result = request.upload(this.responseHandler);
            if (result.uploadCompleted()) {
                callback.progress(this.streamSize, this.streamSize);
                callback.success(result.getItem());
                break;
            }
            if (result.chunkCompleted()) {
                callback.progress(this.readSoFar, this.streamSize);
            } else if (result.hasError()) {
                callback.failure(result.getError());
                break;
            }
            this.readSoFar += (long)read;
        }
    }

    public void upload(IProgressCallback<UploadType> callback, int ... configs) throws IOException {
        this.upload(null, callback, configs);
    }
}

