// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IWorkbookCommentRequest;
import com.microsoft.graph.requests.extensions.WorkbookCommentRequest;
import com.microsoft.graph.requests.extensions.IWorkbookCommentReplyCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.WorkbookCommentReplyCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookCommentReplyRequestBuilder;
import com.microsoft.graph.requests.extensions.WorkbookCommentReplyRequestBuilder;

import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Comment Request Builder.
 */
public class WorkbookCommentRequestBuilder extends BaseRequestBuilder implements IWorkbookCommentRequestBuilder {

    /**
     * The request builder for the WorkbookComment
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WorkbookCommentRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @return the IWorkbookCommentRequest instance
     */
    public IWorkbookCommentRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the IWorkbookCommentRequest instance
     */
    public IWorkbookCommentRequest buildRequest(final java.util.List<? extends Option> requestOptions) {
        return new WorkbookCommentRequest(getRequestUrl(), getClient(), requestOptions);
    }


    public IWorkbookCommentReplyCollectionRequestBuilder replies() {
        return new WorkbookCommentReplyCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("replies"), getClient(), null);
    }

    public IWorkbookCommentReplyRequestBuilder replies(final String id) {
        return new WorkbookCommentReplyRequestBuilder(getRequestUrlWithAdditionalSegment("replies") + "/" + id, getClient(), null);
    }
}

