/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.ContactFolder;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ContactFolderCollectionPage;
import com.microsoft.graph.requests.extensions.ContactFolderCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ContactFolderCollectionResponse;
import com.microsoft.graph.requests.extensions.ContactFolderRequestBuilder;
import com.microsoft.graph.requests.extensions.IContactFolderCollectionPage;
import com.microsoft.graph.requests.extensions.IContactFolderCollectionRequest;
import java.util.List;

public class ContactFolderCollectionRequest
extends BaseCollectionRequest<ContactFolderCollectionResponse, IContactFolderCollectionPage>
implements IContactFolderCollectionRequest {
    public ContactFolderCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ContactFolderCollectionResponse.class, IContactFolderCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IContactFolderCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(ContactFolderCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IContactFolderCollectionPage get() throws ClientException {
        ContactFolderCollectionResponse response = (ContactFolderCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(ContactFolder newContactFolder, ICallback<ContactFolder> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ContactFolderRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newContactFolder, callback);
    }

    @Override
    public ContactFolder post(ContactFolder newContactFolder) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ContactFolderRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newContactFolder);
    }

    @Override
    public IContactFolderCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IContactFolderCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IContactFolderCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IContactFolderCollectionPage buildFromResponse(ContactFolderCollectionResponse response) {
        ContactFolderCollectionRequestBuilder builder = response.nextLink != null ? new ContactFolderCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ContactFolderCollectionPage page = new ContactFolderCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

