// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.Windows10CompliancePolicy;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Windows10Compliance Policy Request.
 */
public interface IWindows10CompliancePolicyRequest extends IHttpRequest {

    /**
     * Gets the Windows10CompliancePolicy from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<Windows10CompliancePolicy> callback);

    /**
     * Gets the Windows10CompliancePolicy from the service
     *
     * @return the Windows10CompliancePolicy from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Windows10CompliancePolicy get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<Windows10CompliancePolicy> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this Windows10CompliancePolicy with a source
     *
     * @param sourceWindows10CompliancePolicy the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final Windows10CompliancePolicy sourceWindows10CompliancePolicy, final ICallback<Windows10CompliancePolicy> callback);

    /**
     * Patches this Windows10CompliancePolicy with a source
     *
     * @param sourceWindows10CompliancePolicy the source object with updates
     * @return the updated Windows10CompliancePolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Windows10CompliancePolicy patch(final Windows10CompliancePolicy sourceWindows10CompliancePolicy) throws ClientException;

    /**
     * Posts a Windows10CompliancePolicy with a new object
     *
     * @param newWindows10CompliancePolicy the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final Windows10CompliancePolicy newWindows10CompliancePolicy, final ICallback<Windows10CompliancePolicy> callback);

    /**
     * Posts a Windows10CompliancePolicy with a new object
     *
     * @param newWindows10CompliancePolicy the new object to create
     * @return the created Windows10CompliancePolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Windows10CompliancePolicy post(final Windows10CompliancePolicy newWindows10CompliancePolicy) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IWindows10CompliancePolicyRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IWindows10CompliancePolicyRequest expand(final String value);

}

