// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Education School Collection With References Request Builder.
 */
public class EducationSchoolCollectionWithReferencesRequestBuilder extends BaseRequestBuilder implements IEducationSchoolCollectionWithReferencesRequestBuilder {

    /**
     * The request builder for this collection of EducationUser
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public EducationSchoolCollectionWithReferencesRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    public IEducationSchoolCollectionWithReferencesRequest buildRequest() {
        return buildRequest(getOptions());
    }

    public IEducationSchoolCollectionWithReferencesRequest buildRequest(final java.util.List<? extends Option> requestOptions) {
        return new EducationSchoolCollectionWithReferencesRequest(getRequestUrl(), getClient(), requestOptions);
    }

    public IEducationSchoolWithReferenceRequestBuilder byId(final String id) {
        return new EducationSchoolWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment(id), getClient(), getOptions());
    }

    public IEducationSchoolCollectionReferenceRequestBuilder references(){
        return new EducationSchoolCollectionReferenceRequestBuilder(getRequestUrl() + "/$ref", getClient(), getOptions());
    }
}
