// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IOnenotePageRequest;
import com.microsoft.graph.requests.extensions.OnenotePageRequest;
import com.microsoft.graph.requests.extensions.IOnenoteSectionRequestBuilder;
import com.microsoft.graph.requests.extensions.OnenoteSectionRequestBuilder;
import com.microsoft.graph.requests.extensions.INotebookRequestBuilder;
import com.microsoft.graph.requests.extensions.NotebookRequestBuilder;
import com.microsoft.graph.requests.extensions.IOnenotePageStreamRequestBuilder;
import com.microsoft.graph.requests.extensions.OnenotePageStreamRequestBuilder;
import com.microsoft.graph.models.extensions.OnenotePatchContentCommand;
import com.microsoft.graph.requests.extensions.IOnenotePageOnenotePatchContentRequestBuilder;
import com.microsoft.graph.requests.extensions.OnenotePageOnenotePatchContentRequestBuilder;
import com.microsoft.graph.requests.extensions.IOnenotePageCopyToSectionRequestBuilder;
import com.microsoft.graph.requests.extensions.OnenotePageCopyToSectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IOnenotePagePreviewRequestBuilder;
import com.microsoft.graph.requests.extensions.OnenotePagePreviewRequestBuilder;

import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Onenote Page Request Builder.
 */
public class OnenotePageRequestBuilder extends BaseRequestBuilder implements IOnenotePageRequestBuilder {

    /**
     * The request builder for the OnenotePage
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public OnenotePageRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @return the IOnenotePageRequest instance
     */
    public IOnenotePageRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the IOnenotePageRequest instance
     */
    public IOnenotePageRequest buildRequest(final java.util.List<? extends Option> requestOptions) {
        return new OnenotePageRequest(getRequestUrl(), getClient(), requestOptions);
    }



    /**
     * Gets the request builder for OnenoteSection
     *
     * @return the IOnenoteSectionRequestBuilder instance
     */
    public IOnenoteSectionRequestBuilder parentSection() {
        return new OnenoteSectionRequestBuilder(getRequestUrlWithAdditionalSegment("parentSection"), getClient(), null);
    }

    /**
     * Gets the request builder for Notebook
     *
     * @return the INotebookRequestBuilder instance
     */
    public INotebookRequestBuilder parentNotebook() {
        return new NotebookRequestBuilder(getRequestUrlWithAdditionalSegment("parentNotebook"), getClient(), null);
    }

    public IOnenotePageStreamRequestBuilder content() {
        return new OnenotePageStreamRequestBuilder(getRequestUrlWithAdditionalSegment("content"), getClient(), null);
    }

    public IOnenotePageOnenotePatchContentRequestBuilder onenotePatchContent(final java.util.List<OnenotePatchContentCommand> commands) {
        return new OnenotePageOnenotePatchContentRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.onenotePatchContent"), getClient(), null, commands);
    }

    public IOnenotePageCopyToSectionRequestBuilder copyToSection(final String id, final String groupId, final String siteCollectionId, final String siteId) {
        return new OnenotePageCopyToSectionRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.copyToSection"), getClient(), null, id, groupId, siteCollectionId, siteId);
    }

    public IOnenotePagePreviewRequestBuilder preview() {
        return new OnenotePagePreviewRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.preview"), getClient(), null);
    }
}

