// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Managed Device With Reference Request.
 */
public class ManagedDeviceWithReferenceRequest extends BaseRequest implements IManagedDeviceWithReferenceRequest {

    /**
     * The request for the ManagedDevice
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ManagedDeviceWithReferenceRequest(String requestUrl, IBaseClient client, java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ManagedDevice.class);
    }

    public void post(final ManagedDevice newManagedDevice, final IJsonBackedObject payload, final ICallback<ManagedDevice> callback) {
        send(HttpMethod.POST, callback, payload);
    }

    public ManagedDevice post(final ManagedDevice newManagedDevice, final IJsonBackedObject payload) throws ClientException {
        IJsonBackedObject response = send(HttpMethod.POST, payload);
        if (response != null){
            return newManagedDevice;
        }
        return null;
    }

    public void get(final ICallback<ManagedDevice> callback) {
        send(HttpMethod.GET, callback, null);
    }

    public ManagedDevice get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

	public void delete(final ICallback<ManagedDevice> callback) {
		send(HttpMethod.DELETE, callback, null);
	}

	public void delete() throws ClientException {
		send(HttpMethod.DELETE, null);
	}

	public void patch(final ManagedDevice sourceManagedDevice, final ICallback<ManagedDevice> callback) {
		send(HttpMethod.PATCH, callback, sourceManagedDevice);
	}

	public ManagedDevice patch(final ManagedDevice sourceManagedDevice) throws ClientException {
		return send(HttpMethod.PATCH, sourceManagedDevice);
	}


    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public IManagedDeviceWithReferenceRequest select(final String value) {
        getQueryOptions().add(new QueryOption("$select", value));
        return (IManagedDeviceWithReferenceRequest)this;
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public IManagedDeviceWithReferenceRequest expand(final String value) {
        getQueryOptions().add(new QueryOption("$expand", value));
        return (ManagedDeviceWithReferenceRequest)this;
    }
}
