// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.TermsAndConditionsAcceptanceStatus;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Terms And Conditions Acceptance Status Request.
 */
public interface ITermsAndConditionsAcceptanceStatusRequest extends IHttpRequest {

    /**
     * Gets the TermsAndConditionsAcceptanceStatus from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<TermsAndConditionsAcceptanceStatus> callback);

    /**
     * Gets the TermsAndConditionsAcceptanceStatus from the service
     *
     * @return the TermsAndConditionsAcceptanceStatus from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    TermsAndConditionsAcceptanceStatus get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<TermsAndConditionsAcceptanceStatus> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this TermsAndConditionsAcceptanceStatus with a source
     *
     * @param sourceTermsAndConditionsAcceptanceStatus the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final TermsAndConditionsAcceptanceStatus sourceTermsAndConditionsAcceptanceStatus, final ICallback<TermsAndConditionsAcceptanceStatus> callback);

    /**
     * Patches this TermsAndConditionsAcceptanceStatus with a source
     *
     * @param sourceTermsAndConditionsAcceptanceStatus the source object with updates
     * @return the updated TermsAndConditionsAcceptanceStatus
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    TermsAndConditionsAcceptanceStatus patch(final TermsAndConditionsAcceptanceStatus sourceTermsAndConditionsAcceptanceStatus) throws ClientException;

    /**
     * Posts a TermsAndConditionsAcceptanceStatus with a new object
     *
     * @param newTermsAndConditionsAcceptanceStatus the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final TermsAndConditionsAcceptanceStatus newTermsAndConditionsAcceptanceStatus, final ICallback<TermsAndConditionsAcceptanceStatus> callback);

    /**
     * Posts a TermsAndConditionsAcceptanceStatus with a new object
     *
     * @param newTermsAndConditionsAcceptanceStatus the new object to create
     * @return the created TermsAndConditionsAcceptanceStatus
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    TermsAndConditionsAcceptanceStatus post(final TermsAndConditionsAcceptanceStatus newTermsAndConditionsAcceptanceStatus) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    ITermsAndConditionsAcceptanceStatusRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    ITermsAndConditionsAcceptanceStatusRequest expand(final String value);

}

