// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.WorkbookChartGridlinesFormat;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Workbook Chart Gridlines Format Request.
 */
public interface IWorkbookChartGridlinesFormatRequest extends IHttpRequest {

    /**
     * Gets the WorkbookChartGridlinesFormat from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<WorkbookChartGridlinesFormat> callback);

    /**
     * Gets the WorkbookChartGridlinesFormat from the service
     *
     * @return the WorkbookChartGridlinesFormat from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookChartGridlinesFormat get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<WorkbookChartGridlinesFormat> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this WorkbookChartGridlinesFormat with a source
     *
     * @param sourceWorkbookChartGridlinesFormat the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final WorkbookChartGridlinesFormat sourceWorkbookChartGridlinesFormat, final ICallback<WorkbookChartGridlinesFormat> callback);

    /**
     * Patches this WorkbookChartGridlinesFormat with a source
     *
     * @param sourceWorkbookChartGridlinesFormat the source object with updates
     * @return the updated WorkbookChartGridlinesFormat
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookChartGridlinesFormat patch(final WorkbookChartGridlinesFormat sourceWorkbookChartGridlinesFormat) throws ClientException;

    /**
     * Posts a WorkbookChartGridlinesFormat with a new object
     *
     * @param newWorkbookChartGridlinesFormat the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final WorkbookChartGridlinesFormat newWorkbookChartGridlinesFormat, final ICallback<WorkbookChartGridlinesFormat> callback);

    /**
     * Posts a WorkbookChartGridlinesFormat with a new object
     *
     * @param newWorkbookChartGridlinesFormat the new object to create
     * @return the created WorkbookChartGridlinesFormat
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookChartGridlinesFormat post(final WorkbookChartGridlinesFormat newWorkbookChartGridlinesFormat) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IWorkbookChartGridlinesFormatRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IWorkbookChartGridlinesFormatRequest expand(final String value);

}

