/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.TelecomExpenseManagementPartner;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ITelecomExpenseManagementPartnerCollectionPage;
import com.microsoft.graph.requests.extensions.ITelecomExpenseManagementPartnerCollectionRequest;
import com.microsoft.graph.requests.extensions.TelecomExpenseManagementPartnerCollectionPage;
import com.microsoft.graph.requests.extensions.TelecomExpenseManagementPartnerCollectionRequest;
import com.microsoft.graph.requests.extensions.TelecomExpenseManagementPartnerCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.TelecomExpenseManagementPartnerRequestBuilder;
import com.microsoft.graph.requests.generated.BaseTelecomExpenseManagementPartnerCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseTelecomExpenseManagementPartnerCollectionRequest;
import java.util.List;

public class BaseTelecomExpenseManagementPartnerCollectionRequest
extends BaseCollectionRequest<BaseTelecomExpenseManagementPartnerCollectionResponse, ITelecomExpenseManagementPartnerCollectionPage>
implements IBaseTelecomExpenseManagementPartnerCollectionRequest {
    public BaseTelecomExpenseManagementPartnerCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseTelecomExpenseManagementPartnerCollectionResponse.class, ITelecomExpenseManagementPartnerCollectionPage.class);
    }

    @Override
    public void get(final ICallback<ITelecomExpenseManagementPartnerCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseTelecomExpenseManagementPartnerCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ITelecomExpenseManagementPartnerCollectionPage get() throws ClientException {
        BaseTelecomExpenseManagementPartnerCollectionResponse response = (BaseTelecomExpenseManagementPartnerCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(TelecomExpenseManagementPartner newTelecomExpenseManagementPartner, ICallback<TelecomExpenseManagementPartner> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new TelecomExpenseManagementPartnerRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newTelecomExpenseManagementPartner, callback);
    }

    @Override
    public TelecomExpenseManagementPartner post(TelecomExpenseManagementPartner newTelecomExpenseManagementPartner) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new TelecomExpenseManagementPartnerRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newTelecomExpenseManagementPartner);
    }

    @Override
    public ITelecomExpenseManagementPartnerCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (TelecomExpenseManagementPartnerCollectionRequest)this;
    }

    @Override
    public ITelecomExpenseManagementPartnerCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (TelecomExpenseManagementPartnerCollectionRequest)this;
    }

    @Override
    public ITelecomExpenseManagementPartnerCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (TelecomExpenseManagementPartnerCollectionRequest)this;
    }

    public ITelecomExpenseManagementPartnerCollectionPage buildFromResponse(BaseTelecomExpenseManagementPartnerCollectionResponse response) {
        TelecomExpenseManagementPartnerCollectionRequestBuilder builder = response.nextLink != null ? new TelecomExpenseManagementPartnerCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        TelecomExpenseManagementPartnerCollectionPage page = new TelecomExpenseManagementPartnerCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

