/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.TeamsTab;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ITeamsTabCollectionPage;
import com.microsoft.graph.requests.extensions.ITeamsTabCollectionRequest;
import com.microsoft.graph.requests.extensions.TeamsTabCollectionPage;
import com.microsoft.graph.requests.extensions.TeamsTabCollectionRequest;
import com.microsoft.graph.requests.extensions.TeamsTabCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.TeamsTabRequestBuilder;
import com.microsoft.graph.requests.generated.BaseTeamsTabCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseTeamsTabCollectionRequest;
import java.util.List;

public class BaseTeamsTabCollectionRequest
extends BaseCollectionRequest<BaseTeamsTabCollectionResponse, ITeamsTabCollectionPage>
implements IBaseTeamsTabCollectionRequest {
    public BaseTeamsTabCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseTeamsTabCollectionResponse.class, ITeamsTabCollectionPage.class);
    }

    @Override
    public void get(final ICallback<ITeamsTabCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseTeamsTabCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ITeamsTabCollectionPage get() throws ClientException {
        BaseTeamsTabCollectionResponse response = (BaseTeamsTabCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(TeamsTab newTeamsTab, ICallback<TeamsTab> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new TeamsTabRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newTeamsTab, callback);
    }

    @Override
    public TeamsTab post(TeamsTab newTeamsTab) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new TeamsTabRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newTeamsTab);
    }

    @Override
    public ITeamsTabCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (TeamsTabCollectionRequest)this;
    }

    @Override
    public ITeamsTabCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (TeamsTabCollectionRequest)this;
    }

    @Override
    public ITeamsTabCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (TeamsTabCollectionRequest)this;
    }

    public ITeamsTabCollectionPage buildFromResponse(BaseTeamsTabCollectionResponse response) {
        TeamsTabCollectionRequestBuilder builder = response.nextLink != null ? new TeamsTabCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        TeamsTabCollectionPage page = new TeamsTabCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

