/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.TeamsAsyncOperation;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ITeamsAsyncOperationCollectionPage;
import com.microsoft.graph.requests.extensions.ITeamsAsyncOperationCollectionRequest;
import com.microsoft.graph.requests.extensions.TeamsAsyncOperationCollectionPage;
import com.microsoft.graph.requests.extensions.TeamsAsyncOperationCollectionRequest;
import com.microsoft.graph.requests.extensions.TeamsAsyncOperationCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.TeamsAsyncOperationRequestBuilder;
import com.microsoft.graph.requests.generated.BaseTeamsAsyncOperationCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseTeamsAsyncOperationCollectionRequest;
import java.util.List;

public class BaseTeamsAsyncOperationCollectionRequest
extends BaseCollectionRequest<BaseTeamsAsyncOperationCollectionResponse, ITeamsAsyncOperationCollectionPage>
implements IBaseTeamsAsyncOperationCollectionRequest {
    public BaseTeamsAsyncOperationCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseTeamsAsyncOperationCollectionResponse.class, ITeamsAsyncOperationCollectionPage.class);
    }

    @Override
    public void get(final ICallback<ITeamsAsyncOperationCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseTeamsAsyncOperationCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ITeamsAsyncOperationCollectionPage get() throws ClientException {
        BaseTeamsAsyncOperationCollectionResponse response = (BaseTeamsAsyncOperationCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(TeamsAsyncOperation newTeamsAsyncOperation, ICallback<TeamsAsyncOperation> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new TeamsAsyncOperationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newTeamsAsyncOperation, callback);
    }

    @Override
    public TeamsAsyncOperation post(TeamsAsyncOperation newTeamsAsyncOperation) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new TeamsAsyncOperationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newTeamsAsyncOperation);
    }

    @Override
    public ITeamsAsyncOperationCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (TeamsAsyncOperationCollectionRequest)this;
    }

    @Override
    public ITeamsAsyncOperationCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (TeamsAsyncOperationCollectionRequest)this;
    }

    @Override
    public ITeamsAsyncOperationCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (TeamsAsyncOperationCollectionRequest)this;
    }

    public ITeamsAsyncOperationCollectionPage buildFromResponse(BaseTeamsAsyncOperationCollectionResponse response) {
        TeamsAsyncOperationCollectionRequestBuilder builder = response.nextLink != null ? new TeamsAsyncOperationCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        TeamsAsyncOperationCollectionPage page = new TeamsAsyncOperationCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

