/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.TeamsAppDefinition;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ITeamsAppDefinitionCollectionPage;
import com.microsoft.graph.requests.extensions.ITeamsAppDefinitionCollectionRequest;
import com.microsoft.graph.requests.extensions.TeamsAppDefinitionCollectionPage;
import com.microsoft.graph.requests.extensions.TeamsAppDefinitionCollectionRequest;
import com.microsoft.graph.requests.extensions.TeamsAppDefinitionCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.TeamsAppDefinitionRequestBuilder;
import com.microsoft.graph.requests.generated.BaseTeamsAppDefinitionCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseTeamsAppDefinitionCollectionRequest;
import java.util.List;

public class BaseTeamsAppDefinitionCollectionRequest
extends BaseCollectionRequest<BaseTeamsAppDefinitionCollectionResponse, ITeamsAppDefinitionCollectionPage>
implements IBaseTeamsAppDefinitionCollectionRequest {
    public BaseTeamsAppDefinitionCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseTeamsAppDefinitionCollectionResponse.class, ITeamsAppDefinitionCollectionPage.class);
    }

    @Override
    public void get(final ICallback<ITeamsAppDefinitionCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseTeamsAppDefinitionCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ITeamsAppDefinitionCollectionPage get() throws ClientException {
        BaseTeamsAppDefinitionCollectionResponse response = (BaseTeamsAppDefinitionCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(TeamsAppDefinition newTeamsAppDefinition, ICallback<TeamsAppDefinition> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new TeamsAppDefinitionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newTeamsAppDefinition, callback);
    }

    @Override
    public TeamsAppDefinition post(TeamsAppDefinition newTeamsAppDefinition) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new TeamsAppDefinitionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newTeamsAppDefinition);
    }

    @Override
    public ITeamsAppDefinitionCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (TeamsAppDefinitionCollectionRequest)this;
    }

    @Override
    public ITeamsAppDefinitionCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (TeamsAppDefinitionCollectionRequest)this;
    }

    @Override
    public ITeamsAppDefinitionCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (TeamsAppDefinitionCollectionRequest)this;
    }

    public ITeamsAppDefinitionCollectionPage buildFromResponse(BaseTeamsAppDefinitionCollectionResponse response) {
        TeamsAppDefinitionCollectionRequestBuilder builder = response.nextLink != null ? new TeamsAppDefinitionCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        TeamsAppDefinitionCollectionPage page = new TeamsAppDefinitionCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

