/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.SharedDriveItem;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ISharedDriveItemCollectionPage;
import com.microsoft.graph.requests.extensions.ISharedDriveItemCollectionRequest;
import com.microsoft.graph.requests.extensions.SharedDriveItemCollectionPage;
import com.microsoft.graph.requests.extensions.SharedDriveItemCollectionRequest;
import com.microsoft.graph.requests.extensions.SharedDriveItemCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.SharedDriveItemRequestBuilder;
import com.microsoft.graph.requests.generated.BaseSharedDriveItemCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseSharedDriveItemCollectionRequest;
import java.util.List;

public class BaseSharedDriveItemCollectionRequest
extends BaseCollectionRequest<BaseSharedDriveItemCollectionResponse, ISharedDriveItemCollectionPage>
implements IBaseSharedDriveItemCollectionRequest {
    public BaseSharedDriveItemCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseSharedDriveItemCollectionResponse.class, ISharedDriveItemCollectionPage.class);
    }

    @Override
    public void get(final ICallback<ISharedDriveItemCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseSharedDriveItemCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ISharedDriveItemCollectionPage get() throws ClientException {
        BaseSharedDriveItemCollectionResponse response = (BaseSharedDriveItemCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(SharedDriveItem newSharedDriveItem, ICallback<SharedDriveItem> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new SharedDriveItemRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newSharedDriveItem, callback);
    }

    @Override
    public SharedDriveItem post(SharedDriveItem newSharedDriveItem) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new SharedDriveItemRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newSharedDriveItem);
    }

    @Override
    public ISharedDriveItemCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (SharedDriveItemCollectionRequest)this;
    }

    @Override
    public ISharedDriveItemCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (SharedDriveItemCollectionRequest)this;
    }

    @Override
    public ISharedDriveItemCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (SharedDriveItemCollectionRequest)this;
    }

    public ISharedDriveItemCollectionPage buildFromResponse(BaseSharedDriveItemCollectionResponse response) {
        SharedDriveItemCollectionRequestBuilder builder = response.nextLink != null ? new SharedDriveItemCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        SharedDriveItemCollectionPage page = new SharedDriveItemCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

