/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IMobileAppCategoryCollectionPage;
import com.microsoft.graph.requests.extensions.IMobileAppCategoryCollectionWithReferencesPage;
import com.microsoft.graph.requests.extensions.IMobileAppCategoryCollectionWithReferencesRequest;
import com.microsoft.graph.requests.extensions.MobileAppCategoryCollectionWithReferencesPage;
import com.microsoft.graph.requests.extensions.MobileAppCategoryCollectionWithReferencesRequest;
import com.microsoft.graph.requests.extensions.MobileAppCategoryCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.generated.BaseMobileAppCategoryCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseMobileAppCategoryCollectionWithReferencesRequest;
import java.util.List;

public class BaseMobileAppCategoryCollectionWithReferencesRequest
extends BaseCollectionRequest<BaseMobileAppCategoryCollectionResponse, IMobileAppCategoryCollectionPage>
implements IBaseMobileAppCategoryCollectionWithReferencesRequest {
    public BaseMobileAppCategoryCollectionWithReferencesRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseMobileAppCategoryCollectionResponse.class, IMobileAppCategoryCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IMobileAppCategoryCollectionWithReferencesPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseMobileAppCategoryCollectionWithReferencesRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IMobileAppCategoryCollectionWithReferencesPage get() throws ClientException {
        BaseMobileAppCategoryCollectionResponse response = (BaseMobileAppCategoryCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public IMobileAppCategoryCollectionWithReferencesRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (MobileAppCategoryCollectionWithReferencesRequest)this;
    }

    @Override
    public IMobileAppCategoryCollectionWithReferencesRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (MobileAppCategoryCollectionWithReferencesRequest)this;
    }

    @Override
    public IMobileAppCategoryCollectionWithReferencesRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (MobileAppCategoryCollectionWithReferencesRequest)this;
    }

    public IMobileAppCategoryCollectionWithReferencesPage buildFromResponse(BaseMobileAppCategoryCollectionResponse response) {
        MobileAppCategoryCollectionWithReferencesRequestBuilder builder = response.nextLink != null ? new MobileAppCategoryCollectionWithReferencesRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        MobileAppCategoryCollectionWithReferencesPage page = new MobileAppCategoryCollectionWithReferencesPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

