/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.http.ReferenceRequestBody;
import com.microsoft.graph.models.extensions.ManagedAppRegistration;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IManagedAppRegistrationCollectionPage;
import com.microsoft.graph.requests.extensions.IManagedAppRegistrationCollectionReferenceRequest;
import com.microsoft.graph.requests.extensions.ManagedAppRegistrationCollectionReferenceRequest;
import com.microsoft.graph.requests.extensions.ManagedAppRegistrationWithReferenceRequestBuilder;
import com.microsoft.graph.requests.generated.BaseManagedAppRegistrationCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseManagedAppRegistrationCollectionReferenceRequest;
import java.util.List;

public class BaseManagedAppRegistrationCollectionReferenceRequest
extends BaseCollectionRequest<BaseManagedAppRegistrationCollectionResponse, IManagedAppRegistrationCollectionPage>
implements IBaseManagedAppRegistrationCollectionReferenceRequest {
    public BaseManagedAppRegistrationCollectionReferenceRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseManagedAppRegistrationCollectionResponse.class, IManagedAppRegistrationCollectionPage.class);
    }

    @Override
    public void post(ManagedAppRegistration newManagedAppRegistration, ICallback<ManagedAppRegistration> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        ReferenceRequestBody body = new ReferenceRequestBody(this.getBaseRequest().getClient().getServiceRoot() + "/deviceAppManagement/managedAppRegistrations/" + newManagedAppRegistration.id);
        new ManagedAppRegistrationWithReferenceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newManagedAppRegistration, body, callback);
    }

    @Override
    public ManagedAppRegistration post(ManagedAppRegistration newManagedAppRegistration) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        ReferenceRequestBody body = new ReferenceRequestBody(this.getBaseRequest().getClient().getServiceRoot() + "/deviceAppManagement/managedAppRegistrations/" + newManagedAppRegistration.id);
        return new ManagedAppRegistrationWithReferenceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newManagedAppRegistration, body);
    }

    public IManagedAppRegistrationCollectionReferenceRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (ManagedAppRegistrationCollectionReferenceRequest)this;
    }

    @Override
    public IManagedAppRegistrationCollectionReferenceRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (ManagedAppRegistrationCollectionReferenceRequest)this;
    }

    @Override
    public IManagedAppRegistrationCollectionReferenceRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (ManagedAppRegistrationCollectionReferenceRequest)this;
    }
}

