/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.DeviceManagementExchangeConnector;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.DeviceManagementExchangeConnectorCollectionPage;
import com.microsoft.graph.requests.extensions.DeviceManagementExchangeConnectorCollectionRequest;
import com.microsoft.graph.requests.extensions.DeviceManagementExchangeConnectorCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DeviceManagementExchangeConnectorRequestBuilder;
import com.microsoft.graph.requests.extensions.IDeviceManagementExchangeConnectorCollectionPage;
import com.microsoft.graph.requests.extensions.IDeviceManagementExchangeConnectorCollectionRequest;
import com.microsoft.graph.requests.generated.BaseDeviceManagementExchangeConnectorCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseDeviceManagementExchangeConnectorCollectionRequest;
import java.util.List;

public class BaseDeviceManagementExchangeConnectorCollectionRequest
extends BaseCollectionRequest<BaseDeviceManagementExchangeConnectorCollectionResponse, IDeviceManagementExchangeConnectorCollectionPage>
implements IBaseDeviceManagementExchangeConnectorCollectionRequest {
    public BaseDeviceManagementExchangeConnectorCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseDeviceManagementExchangeConnectorCollectionResponse.class, IDeviceManagementExchangeConnectorCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IDeviceManagementExchangeConnectorCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseDeviceManagementExchangeConnectorCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDeviceManagementExchangeConnectorCollectionPage get() throws ClientException {
        BaseDeviceManagementExchangeConnectorCollectionResponse response = (BaseDeviceManagementExchangeConnectorCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(DeviceManagementExchangeConnector newDeviceManagementExchangeConnector, ICallback<DeviceManagementExchangeConnector> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new DeviceManagementExchangeConnectorRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDeviceManagementExchangeConnector, callback);
    }

    @Override
    public DeviceManagementExchangeConnector post(DeviceManagementExchangeConnector newDeviceManagementExchangeConnector) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DeviceManagementExchangeConnectorRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDeviceManagementExchangeConnector);
    }

    @Override
    public IDeviceManagementExchangeConnectorCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (DeviceManagementExchangeConnectorCollectionRequest)this;
    }

    @Override
    public IDeviceManagementExchangeConnectorCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (DeviceManagementExchangeConnectorCollectionRequest)this;
    }

    @Override
    public IDeviceManagementExchangeConnectorCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (DeviceManagementExchangeConnectorCollectionRequest)this;
    }

    public IDeviceManagementExchangeConnectorCollectionPage buildFromResponse(BaseDeviceManagementExchangeConnectorCollectionResponse response) {
        DeviceManagementExchangeConnectorCollectionRequestBuilder builder = response.nextLink != null ? new DeviceManagementExchangeConnectorCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DeviceManagementExchangeConnectorCollectionPage page = new DeviceManagementExchangeConnectorCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

