/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.ContentType;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ContentTypeCollectionPage;
import com.microsoft.graph.requests.extensions.ContentTypeCollectionRequest;
import com.microsoft.graph.requests.extensions.ContentTypeCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ContentTypeRequestBuilder;
import com.microsoft.graph.requests.extensions.IContentTypeCollectionPage;
import com.microsoft.graph.requests.extensions.IContentTypeCollectionRequest;
import com.microsoft.graph.requests.generated.BaseContentTypeCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseContentTypeCollectionRequest;
import java.util.List;

public class BaseContentTypeCollectionRequest
extends BaseCollectionRequest<BaseContentTypeCollectionResponse, IContentTypeCollectionPage>
implements IBaseContentTypeCollectionRequest {
    public BaseContentTypeCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseContentTypeCollectionResponse.class, IContentTypeCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IContentTypeCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseContentTypeCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IContentTypeCollectionPage get() throws ClientException {
        BaseContentTypeCollectionResponse response = (BaseContentTypeCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(ContentType newContentType, ICallback<ContentType> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ContentTypeRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newContentType, callback);
    }

    @Override
    public ContentType post(ContentType newContentType) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ContentTypeRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newContentType);
    }

    @Override
    public IContentTypeCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (ContentTypeCollectionRequest)this;
    }

    @Override
    public IContentTypeCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (ContentTypeCollectionRequest)this;
    }

    @Override
    public IContentTypeCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (ContentTypeCollectionRequest)this;
    }

    public IContentTypeCollectionPage buildFromResponse(BaseContentTypeCollectionResponse response) {
        ContentTypeCollectionRequestBuilder builder = response.nextLink != null ? new ContentTypeCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ContentTypeCollectionPage page = new ContentTypeCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

