/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.Channel;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ChannelCollectionPage;
import com.microsoft.graph.requests.extensions.ChannelCollectionRequest;
import com.microsoft.graph.requests.extensions.ChannelCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ChannelRequestBuilder;
import com.microsoft.graph.requests.extensions.IChannelCollectionPage;
import com.microsoft.graph.requests.extensions.IChannelCollectionRequest;
import com.microsoft.graph.requests.generated.BaseChannelCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseChannelCollectionRequest;
import java.util.List;

public class BaseChannelCollectionRequest
extends BaseCollectionRequest<BaseChannelCollectionResponse, IChannelCollectionPage>
implements IBaseChannelCollectionRequest {
    public BaseChannelCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseChannelCollectionResponse.class, IChannelCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IChannelCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseChannelCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IChannelCollectionPage get() throws ClientException {
        BaseChannelCollectionResponse response = (BaseChannelCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(Channel newChannel, ICallback<Channel> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ChannelRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newChannel, callback);
    }

    @Override
    public Channel post(Channel newChannel) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ChannelRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newChannel);
    }

    @Override
    public IChannelCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (ChannelCollectionRequest)this;
    }

    @Override
    public IChannelCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (ChannelCollectionRequest)this;
    }

    @Override
    public IChannelCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (ChannelCollectionRequest)this;
    }

    public IChannelCollectionPage buildFromResponse(BaseChannelCollectionResponse response) {
        ChannelCollectionRequestBuilder builder = response.nextLink != null ? new ChannelCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ChannelCollectionPage page = new ChannelCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

