/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.generated;

import com.google.gson.JsonObject;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.microsoft.graph.models.extensions.Channel;
import com.microsoft.graph.models.extensions.Entity;
import com.microsoft.graph.models.extensions.TeamFunSettings;
import com.microsoft.graph.models.extensions.TeamGuestSettings;
import com.microsoft.graph.models.extensions.TeamMemberSettings;
import com.microsoft.graph.models.extensions.TeamMessagingSettings;
import com.microsoft.graph.models.extensions.TeamsAppInstallation;
import com.microsoft.graph.models.extensions.TeamsAsyncOperation;
import com.microsoft.graph.models.generated.BaseChannel;
import com.microsoft.graph.models.generated.BaseTeamsAppInstallation;
import com.microsoft.graph.models.generated.BaseTeamsAsyncOperation;
import com.microsoft.graph.requests.extensions.ChannelCollectionPage;
import com.microsoft.graph.requests.extensions.TeamsAppInstallationCollectionPage;
import com.microsoft.graph.requests.extensions.TeamsAsyncOperationCollectionPage;
import com.microsoft.graph.requests.generated.BaseChannelCollectionResponse;
import com.microsoft.graph.requests.generated.BaseTeamsAppInstallationCollectionResponse;
import com.microsoft.graph.requests.generated.BaseTeamsAsyncOperationCollectionResponse;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.ISerializer;
import java.util.Arrays;

public class BaseTeam
extends Entity
implements IJsonBackedObject {
    @SerializedName(value="webUrl")
    @Expose
    public String webUrl;
    @SerializedName(value="memberSettings")
    @Expose
    public TeamMemberSettings memberSettings;
    @SerializedName(value="guestSettings")
    @Expose
    public TeamGuestSettings guestSettings;
    @SerializedName(value="messagingSettings")
    @Expose
    public TeamMessagingSettings messagingSettings;
    @SerializedName(value="funSettings")
    @Expose
    public TeamFunSettings funSettings;
    @SerializedName(value="isArchived")
    @Expose
    public Boolean isArchived;
    public ChannelCollectionPage channels;
    public TeamsAppInstallationCollectionPage installedApps;
    public TeamsAsyncOperationCollectionPage operations;
    private JsonObject rawObject;
    private ISerializer serializer;

    @Override
    public JsonObject getRawObject() {
        return this.rawObject;
    }

    @Override
    protected ISerializer getSerializer() {
        return this.serializer;
    }

    @Override
    public void setRawObject(ISerializer serializer, JsonObject json) {
        int i;
        Entity[] array;
        JsonObject[] sourceArray;
        IJsonBackedObject response;
        this.serializer = serializer;
        this.rawObject = json;
        if (json.has("channels")) {
            response = new BaseChannelCollectionResponse();
            if (json.has("channels@odata.nextLink")) {
                response.nextLink = json.get("channels@odata.nextLink").getAsString();
            }
            sourceArray = serializer.deserializeObject(json.get("channels").toString(), JsonObject[].class);
            array = new Channel[sourceArray.length];
            for (i = 0; i < sourceArray.length; ++i) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), Channel.class);
                ((BaseChannel)array[i]).setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            this.channels = new ChannelCollectionPage((BaseChannelCollectionResponse)response, null);
        }
        if (json.has("installedApps")) {
            response = new BaseTeamsAppInstallationCollectionResponse();
            if (json.has("installedApps@odata.nextLink")) {
                ((BaseTeamsAppInstallationCollectionResponse)response).nextLink = json.get("installedApps@odata.nextLink").getAsString();
            }
            sourceArray = serializer.deserializeObject(json.get("installedApps").toString(), JsonObject[].class);
            array = new TeamsAppInstallation[sourceArray.length];
            for (i = 0; i < sourceArray.length; ++i) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), TeamsAppInstallation.class);
                ((BaseTeamsAppInstallation)array[i]).setRawObject(serializer, sourceArray[i]);
            }
            ((BaseTeamsAppInstallationCollectionResponse)response).value = Arrays.asList(array);
            this.installedApps = new TeamsAppInstallationCollectionPage((BaseTeamsAppInstallationCollectionResponse)response, null);
        }
        if (json.has("operations")) {
            response = new BaseTeamsAsyncOperationCollectionResponse();
            if (json.has("operations@odata.nextLink")) {
                ((BaseTeamsAsyncOperationCollectionResponse)response).nextLink = json.get("operations@odata.nextLink").getAsString();
            }
            sourceArray = serializer.deserializeObject(json.get("operations").toString(), JsonObject[].class);
            array = new TeamsAsyncOperation[sourceArray.length];
            for (i = 0; i < sourceArray.length; ++i) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), TeamsAsyncOperation.class);
                ((BaseTeamsAsyncOperation)array[i]).setRawObject(serializer, sourceArray[i]);
            }
            ((BaseTeamsAsyncOperationCollectionResponse)response).value = Arrays.asList(array);
            this.operations = new TeamsAsyncOperationCollectionPage((BaseTeamsAsyncOperationCollectionResponse)response, null);
        }
    }
}

