/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.SettingStateDeviceSummary;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ISettingStateDeviceSummaryCollectionPage;
import com.microsoft.graph.requests.extensions.ISettingStateDeviceSummaryCollectionRequest;
import com.microsoft.graph.requests.extensions.SettingStateDeviceSummaryCollectionPage;
import com.microsoft.graph.requests.extensions.SettingStateDeviceSummaryCollectionRequest;
import com.microsoft.graph.requests.extensions.SettingStateDeviceSummaryCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.SettingStateDeviceSummaryRequestBuilder;
import com.microsoft.graph.requests.generated.BaseSettingStateDeviceSummaryCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseSettingStateDeviceSummaryCollectionRequest;
import java.util.List;

public class BaseSettingStateDeviceSummaryCollectionRequest
extends BaseCollectionRequest<BaseSettingStateDeviceSummaryCollectionResponse, ISettingStateDeviceSummaryCollectionPage>
implements IBaseSettingStateDeviceSummaryCollectionRequest {
    public BaseSettingStateDeviceSummaryCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseSettingStateDeviceSummaryCollectionResponse.class, ISettingStateDeviceSummaryCollectionPage.class);
    }

    @Override
    public void get(final ICallback<ISettingStateDeviceSummaryCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseSettingStateDeviceSummaryCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ISettingStateDeviceSummaryCollectionPage get() throws ClientException {
        BaseSettingStateDeviceSummaryCollectionResponse response = (BaseSettingStateDeviceSummaryCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(SettingStateDeviceSummary newSettingStateDeviceSummary, ICallback<SettingStateDeviceSummary> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new SettingStateDeviceSummaryRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newSettingStateDeviceSummary, callback);
    }

    @Override
    public SettingStateDeviceSummary post(SettingStateDeviceSummary newSettingStateDeviceSummary) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new SettingStateDeviceSummaryRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newSettingStateDeviceSummary);
    }

    @Override
    public ISettingStateDeviceSummaryCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (SettingStateDeviceSummaryCollectionRequest)this;
    }

    @Override
    public ISettingStateDeviceSummaryCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (SettingStateDeviceSummaryCollectionRequest)this;
    }

    @Override
    public ISettingStateDeviceSummaryCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (SettingStateDeviceSummaryCollectionRequest)this;
    }

    public ISettingStateDeviceSummaryCollectionPage buildFromResponse(BaseSettingStateDeviceSummaryCollectionResponse response) {
        SettingStateDeviceSummaryCollectionRequestBuilder builder = response.nextLink != null ? new SettingStateDeviceSummaryCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        SettingStateDeviceSummaryCollectionPage page = new SettingStateDeviceSummaryCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

