/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.NotificationMessageTemplate;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.INotificationMessageTemplateCollectionPage;
import com.microsoft.graph.requests.extensions.INotificationMessageTemplateCollectionRequest;
import com.microsoft.graph.requests.extensions.NotificationMessageTemplateCollectionPage;
import com.microsoft.graph.requests.extensions.NotificationMessageTemplateCollectionRequest;
import com.microsoft.graph.requests.extensions.NotificationMessageTemplateCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.NotificationMessageTemplateRequestBuilder;
import com.microsoft.graph.requests.generated.BaseNotificationMessageTemplateCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseNotificationMessageTemplateCollectionRequest;
import java.util.List;

public class BaseNotificationMessageTemplateCollectionRequest
extends BaseCollectionRequest<BaseNotificationMessageTemplateCollectionResponse, INotificationMessageTemplateCollectionPage>
implements IBaseNotificationMessageTemplateCollectionRequest {
    public BaseNotificationMessageTemplateCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseNotificationMessageTemplateCollectionResponse.class, INotificationMessageTemplateCollectionPage.class);
    }

    @Override
    public void get(final ICallback<INotificationMessageTemplateCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseNotificationMessageTemplateCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public INotificationMessageTemplateCollectionPage get() throws ClientException {
        BaseNotificationMessageTemplateCollectionResponse response = (BaseNotificationMessageTemplateCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(NotificationMessageTemplate newNotificationMessageTemplate, ICallback<NotificationMessageTemplate> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new NotificationMessageTemplateRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newNotificationMessageTemplate, callback);
    }

    @Override
    public NotificationMessageTemplate post(NotificationMessageTemplate newNotificationMessageTemplate) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new NotificationMessageTemplateRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newNotificationMessageTemplate);
    }

    @Override
    public INotificationMessageTemplateCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (NotificationMessageTemplateCollectionRequest)this;
    }

    @Override
    public INotificationMessageTemplateCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (NotificationMessageTemplateCollectionRequest)this;
    }

    @Override
    public INotificationMessageTemplateCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (NotificationMessageTemplateCollectionRequest)this;
    }

    public INotificationMessageTemplateCollectionPage buildFromResponse(BaseNotificationMessageTemplateCollectionResponse response) {
        NotificationMessageTemplateCollectionRequestBuilder builder = response.nextLink != null ? new NotificationMessageTemplateCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        NotificationMessageTemplateCollectionPage page = new NotificationMessageTemplateCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

