/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.ManagedAppPolicy;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IManagedAppPolicyCollectionPage;
import com.microsoft.graph.requests.extensions.IManagedAppPolicyCollectionRequest;
import com.microsoft.graph.requests.extensions.ManagedAppPolicyCollectionPage;
import com.microsoft.graph.requests.extensions.ManagedAppPolicyCollectionRequest;
import com.microsoft.graph.requests.extensions.ManagedAppPolicyCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ManagedAppPolicyRequestBuilder;
import com.microsoft.graph.requests.generated.BaseManagedAppPolicyCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseManagedAppPolicyCollectionRequest;
import java.util.List;

public class BaseManagedAppPolicyCollectionRequest
extends BaseCollectionRequest<BaseManagedAppPolicyCollectionResponse, IManagedAppPolicyCollectionPage>
implements IBaseManagedAppPolicyCollectionRequest {
    public BaseManagedAppPolicyCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseManagedAppPolicyCollectionResponse.class, IManagedAppPolicyCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IManagedAppPolicyCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseManagedAppPolicyCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IManagedAppPolicyCollectionPage get() throws ClientException {
        BaseManagedAppPolicyCollectionResponse response = (BaseManagedAppPolicyCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(ManagedAppPolicy newManagedAppPolicy, ICallback<ManagedAppPolicy> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ManagedAppPolicyRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newManagedAppPolicy, callback);
    }

    @Override
    public ManagedAppPolicy post(ManagedAppPolicy newManagedAppPolicy) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ManagedAppPolicyRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newManagedAppPolicy);
    }

    @Override
    public IManagedAppPolicyCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (ManagedAppPolicyCollectionRequest)this;
    }

    @Override
    public IManagedAppPolicyCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (ManagedAppPolicyCollectionRequest)this;
    }

    @Override
    public IManagedAppPolicyCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (ManagedAppPolicyCollectionRequest)this;
    }

    public IManagedAppPolicyCollectionPage buildFromResponse(BaseManagedAppPolicyCollectionResponse response) {
        ManagedAppPolicyCollectionRequestBuilder builder = response.nextLink != null ? new ManagedAppPolicyCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ManagedAppPolicyCollectionPage page = new ManagedAppPolicyCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

